% Demonstration of a numerical integration of a set of two ordinary
% differential equations

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

% data

clear all

tspan = 0:0.1:2;   % We want output every 0.1 s up to 2 s

k1 = 1;            % Model data
k2 = 2;

c0(1) = 1;         % Running variable for c1 is C(:,1)
c0(2) = 2;         % Running variable for c2 is C(:,2)

% Call of differential equation solver

options = odeset('RelTol', 1e-6, 'AbsTol', 1e-8, 'InitialStep', 0.01);
[T,C] = ode45(@f,tspan,c0,options,k1,k2);

% Output

figure(1)
plot(T,C(:,1))
xlabel('Time (s)');
ylabel('Concentration c1');
figure(2)
plot(T,C(:,2))
xlabel('Time (s)');
ylabel('Concentration c2');
T
C
[s1,s2] = size(T);
conversion = (C(1,1)-C(s1,1))/C(1,1)
